package com.agilex.healthcare.directscheduling.mdws.connection;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import java.util.Map;

public class PoolConfiguration {

	private static int DEFAULT_POOL_SIZE = 1;
	private static int DEFAULT_MAX_POOL_SIZE = 5;
	private static int DEFAULT_TIMEOUT_IN_MILLIS = 300000; // 5 minutes
	private static boolean DEFAULT_POOL_SETTING = false;

	private int minimumPoolSize = DEFAULT_POOL_SIZE;
	private int maxPoolSize = DEFAULT_MAX_POOL_SIZE;
	private int connectionTimeoutInMilliseconds = DEFAULT_TIMEOUT_IN_MILLIS;
	private String endPointUrl;
	private String siteCodes;
	private String serviceAccessCode;
	private String serviceVerifyCode;
	private boolean pooled = DEFAULT_POOL_SETTING;

	public int getMinimumPoolSize() {
		return minimumPoolSize;
	}

	public void setMinimumPoolSize(int minimumPoolSize) {
		this.minimumPoolSize = minimumPoolSize;
	}

	public int getMaxPoolSize() {
		return maxPoolSize;
	}

	public void setMaxPoolSize(int maxPoolSize) {
		this.maxPoolSize = maxPoolSize;
	}

	public int getConnectionTimeoutInMilliseconds() {
		return connectionTimeoutInMilliseconds;
	}

	public void setConnectionTimeoutInMilliseconds(int connectionTimeoutInMilliseconds) {
		this.connectionTimeoutInMilliseconds = connectionTimeoutInMilliseconds;
	}

	public String getSiteCodes() {
		return siteCodes;
	}

	public void setSiteCodes(String siteCodes) {
		this.siteCodes = siteCodes;
	}

	public String getServiceAccessCode() {
		return serviceAccessCode;
	}

	public void setServiceAccessCode(String serviceAccessCode) {
		this.serviceAccessCode = serviceAccessCode;
	}

	public String getServiceVerifyCode() {
		return serviceVerifyCode;
	}

	public void setServiceVerifyCode(String serviceVerifyCode) {
		this.serviceVerifyCode = serviceVerifyCode;
	}

	public String getEndPointUrl() {
		return endPointUrl;
	}

	public void setEndPointUrl(String endPointUrl) {
		this.endPointUrl = endPointUrl;
	}

	public boolean isPooled() {
		return pooled;
	}

	public void setPooled(boolean pooled) {
		this.pooled = pooled;
	}

	public void load() {
		 ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext(new String[] {"mdwsConfiguration.xml" });
		 BeanFactory beanFactory = (BeanFactory) appContext;

		 @SuppressWarnings("unchecked")
		 Map<String, String> poolProperties = (Map<String, String>) beanFactory.getBean("mdwsConnectionProperites");

		 endPointUrl = poolProperties.get("pool.endPointUrl");
		 siteCodes = poolProperties.get("pool.siteCodes");
		 serviceAccessCode = poolProperties.get("pool.serviceAccessCode");
		 serviceVerifyCode = poolProperties.get("pool.serviceVerifyCode");

		 String minPoolSize = poolProperties.get("pool.minimumPoolSize");
		 String maxPoolSize = poolProperties.get("pool.maximumPoolSize");
		 String connectionRefreshTimeoutInMilliseconds = poolProperties.get("pool.connectionRefreshTimeoutInMilliseconds");
		 String usePool = poolProperties.get("pool.usePool");

		 if(usePool != null && "true".equalsIgnoreCase(usePool))
			 pooled = true;

		 if(minPoolSize != null)
			 minimumPoolSize = Integer.parseInt(minPoolSize);

		 if(maxPoolSize != null)
			 this.maxPoolSize = Integer.parseInt(maxPoolSize);

		 if(connectionRefreshTimeoutInMilliseconds != null)
			 this.connectionTimeoutInMilliseconds = Integer.parseInt(connectionRefreshTimeoutInMilliseconds);


	}

}
